# SalesPipe CRM

## Overview

SalesPipe is a sales CRM application for managing leads, contacts, deals, and sales pipeline stages. It features a web-to-lead form for capturing prospects, a kanban-style pipeline board for deal tracking, contact management, and analytics dashboards. The application follows a full-stack TypeScript architecture with a React frontend and Express backend.

## User Preferences

Preferred communication style: Simple, everyday language.

## System Architecture

### Frontend Architecture
- **Framework**: React 18 with TypeScript
- **Routing**: Wouter (lightweight client-side routing)
- **State Management**: TanStack React Query for server state and caching
- **UI Components**: shadcn/ui component library built on Radix UI primitives
- **Styling**: Tailwind CSS with CSS variables for theming (light/dark mode support)
- **Forms**: React Hook Form with Zod validation
- **Charts**: Recharts for analytics visualizations
- **Build Tool**: Vite with path aliases (`@/` for client/src, `@shared/` for shared)

### Backend Architecture
- **Framework**: Express 5 with TypeScript
- **Database ORM**: Drizzle ORM with PostgreSQL
- **Schema Validation**: Zod with drizzle-zod for type-safe schema generation
- **API Pattern**: RESTful endpoints under `/api/` prefix
- **Development**: Vite middleware integration for HMR during development

### Data Layer
- **Database**: PostgreSQL with Drizzle ORM
- **Schema Location**: `shared/schema.ts` contains all table definitions
- **Tables**:
  - `pipeline_stages`: Sales pipeline stages with order and color
  - `contacts`: Customer contact information
  - `leads`: Inbound leads from web forms
  - `deals`: Sales opportunities linked to stages and contacts

### Project Structure
```
├── client/           # React frontend
│   └── src/
│       ├── components/  # UI components (shadcn/ui + custom)
│       ├── pages/       # Route components
│       ├── hooks/       # Custom React hooks
│       └── lib/         # Utilities and query client
├── server/           # Express backend
│   ├── index.ts      # Server entry point
│   ├── routes.ts     # API route definitions
│   ├── storage.ts    # Database operations
│   └── db.ts         # Database connection
├── shared/           # Shared types and schema
│   └── schema.ts     # Drizzle schema definitions
└── migrations/       # Database migrations
```

### Build System
- Development: `tsx` for running TypeScript directly
- Production: esbuild bundles server, Vite builds client to `dist/`
- Database: `drizzle-kit push` for schema synchronization

## External Dependencies

### Database
- **PostgreSQL**: Primary database, connected via `DATABASE_URL` environment variable
- **Drizzle ORM**: Type-safe database queries and schema management

### UI Framework
- **Radix UI**: Headless UI primitives for accessibility
- **shadcn/ui**: Pre-built component patterns using Radix + Tailwind
- **Lucide React**: Icon library

### Development Tools
- **Vite**: Frontend build and development server
- **Replit Plugins**: Runtime error overlay, cartographer, and dev banner for Replit environment